﻿using gov.va.med.vbecs.BOL;
using System;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class SpecimenItemViewModel : SelectableTestViewModel
    {
        /// <summary>
        /// PendingSpecimenTestModel
        /// </summary>
        public IPendingSpecimenTestModel PendingSpecimenTestModel
        {
            get
            {
                return PendingTestModel as IPendingSpecimenTestModel;
            }
            set
            {
                PendingTestModel = value;
                RaisePropertyChanged(() => PendingSpecimenTestModel);
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="pendingSpecimenTestModel"></param>
        public SpecimenItemViewModel(IPendingSpecimenTestModel pendingSpecimenTestModel)
            : base(pendingSpecimenTestModel)
        {
            if (pendingSpecimenTestModel == null) throw new ArgumentNullException("pendingSpecimenTestModel");

            ReviewComment = pendingSpecimenTestModel.ReviewComment;

            // Make new references via clone so we can check for unsaved changes easier
            if (pendingSpecimenTestModel.TestValidation != null)
            {
                TestValidation = pendingSpecimenTestModel.TestValidation.Clone();
            }            
        }

        /// <summary>
        /// Check for unsaved changes
        /// </summary>
        /// <returns></returns>
        public override bool IsDirty()
        {
            return (ReviewComment != PendingTestModel.ReviewComment)
                || !Equals(TestValidation, PendingSpecimenTestModel.TestValidation);
        }
    }
}
